/*
 * Definitions for Prolific USB Serial Adapter Driver
 *
 *  Copyright (C) 2001
 *      Sam Kuo (kuo@prolific.com.tw)
 *
 *  This program is largely derived from work by the linux-usb group
 *  and associated source files.  Please see the usb/serial files for
 *  individual credits and copyrights.
 *
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2 of the License, or
 * 	(at your option) any later version.
 *
 */
#ifndef __LINUX_USB_SERIAL_PSA_H
#define __LINUX_USB_SERIAL_PSA_H

#define PROLIFIC_SA_VID 0x067B                      /* Vendor Id */
#define PROLIFIC_SA_PID 0x2303                      /* Product Id */

/* Vendor Request Interface */
#define PROLIFIC_SA_VENDOR_REQUEST          0x01
#define PROLIFIC_SA_SET_LINECODING_REQUEST  0x20
#define PROLIFIC_SA_SET_CTRL_LINE_REQUEST   0x22
#define PROLIFIC_SA_SET_BREAK_REQUEST       0x23    /* Set BREAK state */

#define PROLIFIC_SA_SET_REQUEST_CLASS_TYPE  0x21
#define PROLIFIC_SA_SET_REQUEST_VENDOR_TYPE 0x40

// #define PROLIFIC_SA_GET_REQUEST_VENDOR_TYPE 0xC0
#define PROLIFIC_SA_GET_REQUEST_VENDOR_TYPE 0x40    /* note this */

#define PROLIFIC_SA_PARITY_NONE             0
#define PROLIFIC_SA_PARITY_EVEN             1
#define PROLIFIC_SA_PARITY_ODD              2
#define PROLIFIC_SA_PARITY_MARK             3
#define PROLIFIC_SA_PARITY_SPACE            4

#define PROLIFIC_SA_FLOW_NONE               0x0000  /* No flow control */
#define PROLIFIC_SA_FLOW_OCTS               0x0001  /* use CTS input to throttle output */
#define PROLIFIC_SA_FLOW_ODSR               0x0002  /* use DSR input to throttle output */
#define PROLIFIC_SA_FLOW_IDSR               0x0004  /* use DSR input to enable receive */
#define PROLIFIC_SA_FLOW_IDTR               0x0008  /* use DTR output for input flow control */
#define PROLIFIC_SA_FLOW_IRTS               0x0010  /* use RTS output for input flow control */
#define PROLIFIC_SA_FLOW_ORTS               0x0020  /* use RTS to indicate data available to send */
#define PROLIFIC_SA_FLOW_ERRSUB             0x0040  /* ???? guess ???? substitute inline errors */
#define PROLIFIC_SA_FLOW_OXON               0x0080  /* use XON/XOFF for output flow control */
#define PROLIFIC_SA_FLOW_IXON               0x0100  /* use XON/XOFF for input flow control */

/*
 * It seems that the interrupt pipe is closely modelled after the
 * 16550 register layout.  This is probably because the adapter can
 * be used in a "DOS" environment to simulate a standard hardware port.
 */
#define PROLIFIC_SA_LSR_INDEX 8                     /* Line Status Register */
#define PROLIFIC_SA_LSR_RDR   0x01                  /* receive data ready */
#define PROLIFIC_SA_LSR_OE    0x02                  /* overrun error */
#define PROLIFIC_SA_LSR_PE    0x04                  /* parity error */
#define PROLIFIC_SA_LSR_FE    0x08                  /* framing error */
#define PROLIFIC_SA_LSR_BI    0x10                  /* break indicator */
#define PROLIFIC_SA_LSR_ERR   0x80                  /* OE | PE | FE | BI */

#define PROLIFIC_SA_MSR_INDEX 8                     /* Modem Status Register */
#define PROLIFIC_SA_MSR_CTS   0x80                  /* Current CTS */
#define PROLIFIC_SA_MSR_DSR   0x02                  /* Current DSR */
#define PROLIFIC_SA_MSR_RI    0x08                  /* Current RI */
#define PROLIFIC_SA_MSR_CD    0x01                  /* Current CD */
#endif /* __LINUX_USB_SERIAL_PSA_H */
